/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3545;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.FastBlockPortalShape;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.AARotation;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.IntMatrix3;

public class DiligentMatcher {
    public static List<TransformedShape> getMatchableShapeVariants(BlockPortalShape original, int maxShapeLen) {
        ArrayList<TransformedShape> result = new ArrayList<TransformedShape>();
        HashSet<BlockPortalShape> shapeSet = new HashSet<BlockPortalShape>();
        int divFactor = DiligentMatcher.getShapeShrinkFactor(original);
        BlockPortalShape shrinked = DiligentMatcher.shrinkShapeBy(original, divFactor);
        int shrinkedShapeLen = shrinked.getShapeInnerLength();
        int maxMultiplyFactor = (int)Math.floor((double)maxShapeLen / (double)shrinkedShapeLen);
        for (AARotation rotation : AARotation.rotationsSortedByAngle) {
            IntMatrix3 rotationMatrix = rotation.matrix;
            BlockPortalShape rotatedShape = DiligentMatcher.rotateShape(shrinked, rotationMatrix);
            BlockPortalShape newShape = DiligentMatcher.regularizeShape(rotatedShape);
            boolean isNew = shapeSet.add(newShape);
            if (!isNew) continue;
            result.add(new TransformedShape(original, newShape, rotationMatrix, 1.0 / (double)divFactor));
            for (int mul = 2; mul <= maxMultiplyFactor; ++mul) {
                BlockPortalShape expanded = DiligentMatcher.regularizeShape(DiligentMatcher.upscaleShape(rotatedShape, mul));
                isNew = shapeSet.add(expanded);
                if (!isNew) continue;
                result.add(new TransformedShape(original, expanded, rotationMatrix, (double)mul / (double)divFactor));
            }
        }
        return result;
    }

    public static BlockPortalShape regularizeShape(BlockPortalShape rotatedShape) {
        return rotatedShape.getShapeWithMovedAnchor(class_2338.field_10980);
    }

    public static BlockPortalShape rotateShape(BlockPortalShape shape, IntMatrix3 t) {
        Set<class_2338> newArea = shape.area.stream().map(b -> t.transform((class_2382)b)).collect(Collectors.toSet());
        class_2350.class_2351 newAxis = t.transformDirection(class_2350.method_10169((class_2350.class_2351)shape.axis, (class_2350.class_2352)class_2350.class_2352.field_11056)).method_10166();
        return new BlockPortalShape(newArea, newAxis);
    }

    public static int getShapeShrinkFactor(BlockPortalShape shape) {
        HashSet<class_2338> area = new HashSet<class_2338>(shape.area);
        ArrayList<IntBox> boxList = DiligentMatcher.decomposeShape(shape, area);
        IntArrayList sideLenList = new IntArrayList();
        class_3545<class_2350.class_2351, class_2350.class_2351> axs = Helper.getAnotherTwoAxis(shape.axis);
        for (IntBox box : boxList) {
            class_2338 boxSize = box.getSize();
            int a2 = Helper.getCoordinate((class_2382)boxSize, (class_2350.class_2351)axs.method_15442());
            int b2 = Helper.getCoordinate((class_2382)boxSize, (class_2350.class_2351)axs.method_15441());
            sideLenList.add(a2);
            sideLenList.add(b2);
        }
        return (Integer)sideLenList.stream().reduce((a, b) -> IntMath.gcd((int)a, (int)b)).get();
    }

    public static BlockPortalShape shrinkShapeBy(BlockPortalShape shape, int div) {
        Validate.isTrue((div != 0 ? 1 : 0) != 0);
        BlockPortalShape regularized = DiligentMatcher.regularizeShape(shape);
        if (div == 1) {
            return regularized;
        }
        Set<class_2338> newArea = regularized.area.stream().map(b -> new class_2338(Math.floorDiv(b.method_10263(), div), Math.floorDiv(b.method_10264(), div), Math.floorDiv(b.method_10260(), div))).collect(Collectors.toSet());
        return new BlockPortalShape(newArea, regularized.axis);
    }

    public static ArrayList<IntBox> decomposeShape(BlockPortalShape shape, HashSet<class_2338> area) {
        IntBox box;
        ArrayList<IntBox> boxList = new ArrayList<IntBox>();
        while (!area.isEmpty() && (box = DiligentMatcher.splitBoxFromArea(area, shape.axis)) != null) {
            boxList.add(box);
        }
        return boxList;
    }

    public static BlockPortalShape upscaleShape(BlockPortalShape shape, int multiplyFactor) {
        class_3545<class_2350.class_2351, class_2350.class_2351> axs = Helper.getAnotherTwoAxis(shape.axis);
        class_2382 v1 = class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)axs.method_15442()), (class_2350.class_2352)class_2350.class_2352.field_11056).method_10163();
        class_2382 v2 = class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)axs.method_15441()), (class_2350.class_2352)class_2350.class_2352.field_11056).method_10163();
        return new BlockPortalShape(shape.area.stream().flatMap(basePos -> IntStream.range(0, multiplyFactor).boxed().flatMap(dx -> IntStream.range(0, multiplyFactor).mapToObj(dy -> Helper.scale((class_2382)basePos, multiplyFactor).method_10081((class_2382)Helper.scale(v1, dx).method_10081((class_2382)Helper.scale(v2, dy)))))).collect(Collectors.toSet()), shape.axis);
    }

    private static IntBox splitBoxFromArea(Set<class_2338> area, class_2350.class_2351 axis) {
        Iterator<class_2338> iterator = area.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        class_2338 firstElement = iterator.next();
        IntBox expanded = Helper.expandRectangle(firstElement, area::contains, axis);
        expanded.stream().forEach(b -> area.remove(b));
        return expanded;
    }

    public static class TransformedShape {
        public final BlockPortalShape originalShape;
        public final BlockPortalShape transformedShape;
        public final IntMatrix3 rotation;
        public final double scale;
        public final FastBlockPortalShape fastOriginalShape;
        public final FastBlockPortalShape fastTransformedShape;

        public TransformedShape(BlockPortalShape originalShape, BlockPortalShape transformedShape, IntMatrix3 rotation, double scale) {
            this.originalShape = originalShape;
            this.transformedShape = transformedShape;
            this.rotation = rotation;
            this.scale = scale;
            this.fastOriginalShape = FastBlockPortalShape.fromBlockPortalShape(originalShape);
            this.fastTransformedShape = FastBlockPortalShape.fromBlockPortalShape(transformedShape);
        }
    }
}

